#!/usr/bin/env ts-node

// Create an ed25519 keypair from the CLI
//
// Usage:
// ts-node createKeypairCLI.ts

import { createKeypair } from './createKeypair'

function main() {
  const keypair = createKeypair()

  console.log(
    `Public Key: ${Buffer.from(keypair.publicKey).toString('base64')}`,
  )
  console.log(
    `Secret Key: ${Buffer.from(keypair.secretKey).toString('base64')}`,
  )
}

main()
